# DX_CC6_CORE_HOST_SIDE makefile
# CRYS component
#

COMP_NAME := $(EXTAPP_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(VOS_ID) $(CC6_GEN_ID) $(FVOS_ID) $(INIT_ID) $(CRYS_ID) $(KMNG_ID) $(SST_ID)

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(HOST_PATH)VOS6/External/$(VOS_OS)/inc/ \
	$(HOST_PATH)VOS6/External/VOS_API/ \
	$(HOST_PATH)GEN/inc/ \
	$(HOST_PATH)SepIF/inc/ \
	$(HOST_PATH)HostIF/inc/ \
	$(BASE_PATH)Sep_ram/HostIF/inc/ \
	$(HOST_PATH)FVOS/FVOS_API/inc/ \
	$(HOST_PATH)FVOS/$(FVOS_OS_DIR)/inc/ \
	$(HOST_PATH)INIT/inc/ \
	$(HOST_PATH)EXT_APP/inc/ \
	$(HOST_PATH)EXT_APP/QA_HOST_TST/inc \
	$(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/inc \
	$(HOST_PATH)EXT_APP/QA_HOST_TST/SST_HOST_TST/inc \
	$(HOST_PATH)EXT_APP/QA_HOST_TST/HOST_TST_Defines/inc \
	$(HOST_PATH)EXTAPP_ATP/SST_ExtApp_ATP/tinc \
	$(HOST_PATH)DX_CRYS_API/CC6_CRYS_API/inc \
	$(HOST_PATH)DX_CRYS_API/CC6_CRYS_API/tinc \
	$(HOST_PATH)DX_SST6_API/inc \
	$(HOST_PATH)KMNG_API/inc

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	$(HOST_PATH)HostIF/inc/

#global flags for this component
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile
$(COMP_NAME)_CCFLAGS := 

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	DX_ConnectivityTest \
	CRYS_HOST_TST_AES \
	CRYS_HOST_TST_DES \
	CRYS_HOST_TST_DH \
	CRYS_HOST_TST_ECC \
	CRYS_HOST_TST_HASH \
	CRYS_HOST_TST_HMAC \
	CRYS_HOST_TST_RC4 \
	CRYS_HOST_TST_RND \
	CRYS_HOST_TST_RSA \
	ExtApp_HOST_TST_Message \
	ExtApp_HOST_TST_Message_Init \
	ExtApp_HOST_TST_Message_MM


#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)CC6_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)DX_ConnectivityTest.$(OBJEXT): $(HOST_PATH)EXT_APP/src/DX_ConnectivityTest.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HOST_TST_AES.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/src/CRYS_HOST_TST_AES.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HOST_TST_DES.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/src/CRYS_HOST_TST_DES.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HOST_TST_HASH.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/src/CRYS_HOST_TST_HASH.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HOST_TST_HMAC.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/src/CRYS_HOST_TST_HMAC.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HOST_TST_RC4.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/src/CRYS_HOST_TST_RC4.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HOST_TST_RSA.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/src/CRYS_HOST_TST_RSA.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HOST_TST_DH.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/src/CRYS_HOST_TST_DH.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HOST_TST_ECC.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/src/CRYS_HOST_TST_ECC.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HOST_TST_RND.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/CRYS_HOST_TST/src/CRYS_HOST_TST_RND.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ExtApp_HOST_TST_Message.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/src/ExtApp_HOST_TST_Message.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ExtApp_HOST_TST_Message_Init.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/SST_HOST_TST/src/ExtApp_HOST_TST_Message_Init.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ExtApp_HOST_TST_Message_MM.$(OBJEXT): $(HOST_PATH)EXT_APP/QA_HOST_TST/SST_HOST_TST/src/ExtApp_HOST_TST_Message_MM.c
	$(EXTAPP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

